<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class History extends Model 
{

    protected $table = 'histories';
    public $timestamps = true;
    protected $fillable = array('pull_request', 'mainPrice', 'net', 'user_id', 'title', 'order_id', 'family_id', 'driver_id');

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

    public function family()
    {
        return $this->belongsTo('App\User', 'family_id');
    }

    public function driver()
    {
        return $this->belongsTo('App\User', 'driver_id');
    }

}